<?php
session_start();
require_once 'config/database.php';
require_once 'includes/auth.php';
require_once 'includes/security.php';

$auth = new Auth();
$auth->requireAdmin();

$security = new Security();
$csrf_token = $security->generateCSRFToken();

$db = new Database();

// Get dashboard statistics
function getDashboardStats($db) {
    $stats = [
        'total_users' => 0,
        'active_sessions' => 0,
        'recent_activity' => []
    ];
    
    // Get total users
    $sql = "SELECT COUNT(*) as total FROM admin_users WHERE is_active = 1";
    $stmt = $db->prepare($sql);
    if ($db->execute($stmt) && $row = $db->fetchArray($stmt)) {
        $stats['total_users'] = $row['total'];
    }
    
    // Get recent activity
    $sql = "SELECT TOP 10 a.*, u.username 
            FROM admin_activity_log a 
            LEFT JOIN admin_users u ON a.user_id = u.id 
            ORDER BY a.created_at DESC";
    $stmt = $db->prepare($sql);
    if ($db->execute($stmt)) {
        while ($row = $db->fetchArray($stmt)) {
            $stats['recent_activity'][] = $row;
        }
    }
    
    return $stats;
}

$stats = getDashboardStats($db);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #2c3e50;
        }
        .sidebar .nav-link {
            color: #ecf0f1;
            margin: 5px 0;
            border-radius: 5px;
        }
        .sidebar .nav-link:hover {
            background: #34495e;
            color: #fff;
        }
        .sidebar .nav-link.active {
            background: #3498db;
            color: #fff;
        }
        .stat-card {
            border-left: 4px solid #3498db;
            transition: transform 0.2s;
        }
        .stat-card:hover {
            transform: translateY(-2px);
        }
        .navbar-brand {
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container-fluid p-0">
        <!-- Top Navigation -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
            <div class="container-fluid">
                <a class="navbar-brand" href="#">
                    <i class="fas fa-cogs me-2"></i>
                    Admin Panel
                </a>
                <div class="navbar-nav ms-auto">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" 
                           data-bs-toggle="dropdown">
                            <i class="fas fa-user me-1"></i>
                            <?php echo htmlspecialchars($_SESSION['admin_name']); ?>
                            <span class="badge bg-secondary"><?php echo htmlspecialchars($_SESSION['admin_role']); ?></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i>Profile</a></li>
                            <li><a class="dropdown-item" href="settings.php"><i class="fas fa-cog me-2"></i>Settings</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a></li>
                        </ul>
                    </li>
                </div>
            </div>
        </nav>

        <div class="row g-0">
            <!-- Sidebar -->
            <div class="col-lg-2 sidebar d-none d-lg-block">
                <div class="p-3">
                    <div class="text-center text-white mb-4">
                        <h5>Navigation</h5>
                    </div>
                    
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="admin_dashboard.php">
                                <i class="fas fa-tachometer-alt me-2"></i>
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="users.php">
                                <i class="fas fa-users me-2"></i>
                                User Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="reports.php">
                                <i class="fas fa-chart-bar me-2"></i>
                                Reports & Analytics
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="system_logs.php">
                                <i class="fas fa-server me-2"></i>
                                System Logs
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="settings.php">
                                <i class="fas fa-sliders-h me-2"></i>
                                System Settings
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="activity_log.php">
                                <i class="fas fa-history me-2"></i>
                                Activity Log
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-lg-10">
                <div class="p-4">
                    <!-- Page Header -->
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h1 class="h3 mb-0">
                            <i class="fas fa-tachometer-alt me-2 text-primary"></i>
                            Dashboard
                        </h1>
                        <div class="btn-group">
                            <button class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-sync-alt me-1"></i>Refresh
                            </button>
                            <button class="btn btn-outline-secondary btn-sm">
                                <i class="fas fa-download me-1"></i>Export
                            </button>
                        </div>
                    </div>

                    <!-- Stats Cards -->
                    <div class="row g-3 mb-4">
                        <div class="col-xl-3 col-md-6">
                            <div class="card stat-card h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="card-title text-muted text-uppercase small">Total Admins</h6>
                                            <h2 class="mb-0"><?php echo $stats['total_users']; ?></h2>
                                        </div>
                                        <div class="align-self-center">
                                            <i class="fas fa-users fa-2x text-primary opacity-50"></i>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <small class="text-success">
                                            <i class="fas fa-arrow-up me-1"></i>
                                            5.2% from last month
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-3 col-md-6">
                            <div class="card stat-card h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="card-title text-muted text-uppercase small">Active Sessions</h6>
                                            <h2 class="mb-0">12</h2>
                                        </div>
                                        <div class="align-self-center">
                                            <i class="fas fa-signal fa-2x text-success opacity-50"></i>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <small class="text-danger">
                                            <i class="fas fa-arrow-down me-1"></i>
                                            2.1% from yesterday
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-3 col-md-6">
                            <div class="card stat-card h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="card-title text-muted text-uppercase small">System Load</h6>
                                            <h2 class="mb-0">42%</h2>
                                        </div>
                                        <div class="align-self-center">
                                            <i class="fas fa-microchip fa-2x text-warning opacity-50"></i>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <div class="progress" style="height: 4px;">
                                            <div class="progress-bar bg-warning" style="width: 42%"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-3 col-md-6">
                            <div class="card stat-card h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="card-title text-muted text-uppercase small">Uptime</h6>
                                            <h2 class="mb-0">99.9%</h2>
                                        </div>
                                        <div class="align-self-center">
                                            <i class="fas fa-heartbeat fa-2x text-danger opacity-50"></i>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <small class="text-success">
                                            <i class="fas fa-check-circle me-1"></i>
                                            All systems operational
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Activity & System Status -->
                    <div class="row g-3">
                        <!-- Recent Activity -->
                        <div class="col-lg-8">
                            <div class="card h-100">
                                <div class="card-header bg-transparent">
                                    <h5 class="mb-0">
                                        <i class="fas fa-history me-2 text-primary"></i>
                                        Recent Activity
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>User</th>
                                                    <th>Action</th>
                                                    <th>Description</th>
                                                    <th>Time</th>
                                                    <th>IP Address</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($stats['recent_activity'] as $activity): ?>
                                                <tr>
                                                    <td>
                                                        <strong><?php echo htmlspecialchars($activity['username'] ?? 'System'); ?></strong>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-<?php 
                                                            echo $activity['action'] === 'LOGIN_SUCCESS' ? 'success' : 
                                                                 ($activity['action'] === 'LOGIN_FAILED' ? 'danger' : 'info'); 
                                                        ?>">
                                                            <?php echo htmlspecialchars($activity['action']); ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo htmlspecialchars($activity['description']); ?></td>
                                                    <td>
                                                        <small class="text-muted">
                                                            <?php 
                                                                $time = $activity['created_at'];
                                                                if ($time instanceof DateTime) {
                                                                    echo $time->format('M j, H:i');
                                                                } else {
                                                                    echo date('M j, H:i', strtotime($time));
                                                                }
                                                            ?>
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <code><?php echo htmlspecialchars($activity['ip_address']); ?></code>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- System Status -->
                        <div class="col-lg-4">
                            <div class="card h-100">
                                <div class="card-header bg-transparent">
                                    <h5 class="mb-0">
                                        <i class="fas fa-server me-2 text-success"></i>
                                        System Status
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between mb-1">
                                            <strong>Database</strong>
                                            <span class="badge bg-success">Online</span>
                                        </div>
                                        <div class="progress" style="height: 6px;">
                                            <div class="progress-bar bg-success" style="width: 85%"></div>
                                        </div>
                                        <small class="text-muted">85% capacity</small>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between mb-1">
                                            <strong>Web Server</strong>
                                            <span class="badge bg-success">Online</span>
                                        </div>
                                        <div class="progress" style="height: 6px;">
                                            <div class="progress-bar bg-info" style="width: 65%"></div>
                                        </div>
                                        <small class="text-muted">65% load</small>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between mb-1">
                                            <strong>Cache</strong>
                                            <span class="badge bg-warning">Degraded</span>
                                        </div>
                                        <div class="progress" style="height: 6px;">
                                            <div class="progress-bar bg-warning" style="width: 45%"></div>
                                        </div>
                                        <small class="text-muted">45% performance</small>
                                    </div>
                                    
                                    <div class="mt-4">
                                        <h6>Quick Actions</h6>
                                        <div class="d-grid gap-2">
                                            <button class="btn btn-outline-primary btn-sm">
                                                <i class="fas fa-backup me-1"></i>Backup Database
                                            </button>
                                            <button class="btn btn-outline-secondary btn-sm">
                                                <i class="fas fa-trash me-1"></i>Clear Cache
                                            </button>
                                            <button class="btn btn-outline-info btn-sm">
                                                <i class="fas fa-file-export me-1"></i>Export Logs
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Auto-refresh dashboard every 60 seconds
        setInterval(() => {
            window.location.reload();
        }, 60000);
    </script>
</body>
</html>